/*\file ElementConnectivity.c
 *\brief: build element connectivity using node connectivity and elements. 
 */

#include "./ElementConnectivity.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*inputs: */
	double* elements=NULL;
	double* nodeconnectivity=NULL;
	int     nel,nods;
	int     width;

	/*outputs: */
	double* elementconnectivity=NULL;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&ElementConnectivityUsage);
        
	/*Input datasets: */
	FetchData(&elements,&nel,NULL,ELEMENTS);
	FetchData(&nodeconnectivity,&nods,&width,NODECONNECTIVITY);

	/*!Generate internal degree of freedom numbers: */
	ElementConnectivityx(&elementconnectivity, elements,nel, nodeconnectivity, nods, width);

	/*write output datasets: */
	WriteData(ELEMENTCONNECTIVITY,elementconnectivity,nel,3);

	/*Free ressources: */
	xfree((void**)&elements);
	xfree((void**)&nodeconnectivity);

	/*end module: */
	MODULEEND();
}

void ElementConnectivityUsage(void) {
	_printf_(true,"\n");
	_printf_(true,"   usage: elementconnectivity = %s(elements, nodeconnectivity);\n",__FUNCT__);
	_printf_(true,"\n");
}
