/*\file Echo.c
 *\brief:  echo a dataset from a matlab workspace handle.
 */

#include "./Echo.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*input datasets: */
	DataSet* dataset=NULL;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&EchoUsage);

	/*Input datasets: */
	FetchData(&dataset,DATASET);

	/*Echo dataset: */
	dataset->Echo();
	
	/*end module: */
	MODULEEND();
}

void EchoUsage(void)
{
	_printf_(true,"\n");
	_printf_(true,"   usage: %s(m.dataset);\n",__FUNCT__);
	_printf_(true,"\n");
}
