/*\file CreateNodalConstraints.c
 *\brief: reduce g set vector to s set vector (set of single point constraints)
 */

#include "./CreateNodalConstraints.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*input datasets: */
	Nodes *nodes         = NULL;
	int    analysis_type;

	/* output datasets: */
	Vec ys=NULL;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&CreateNodalConstraintsUsage);

	/*Input datasets: */
	FetchData((DataSet**)&nodes,NODES);
	FetchData(&analysis_type,ANALYSISTYPE);

	/*!Reduce vector: */
	CreateNodalConstraintsx(&ys,nodes,analysis_type);

	/*write output datasets: */
	WriteData(YS,ys);

	/*Free ressources: */
	delete nodes;
	VecFree(&ys);

	/*end module: */
	MODULEEND();
}

void CreateNodalConstraintsUsage(void)
{
	_printf_(true,"\n");
	_printf_(true,"   usage: ys = %s(nodes,analysis_type);\n",__FUNCT__);
	_printf_(true,"\n");
}
