/*\file ControlInputSetGradient.c
*\brief: update elements properties using an input  vector
*/

#include "./ControlInputSetGradient.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

/*input datasets: */
Elements   *elements   = NULL;
Nodes      *nodes      = NULL;
Vertices   *vertices   = NULL;
Loads      *loads      = NULL;
Materials  *materials  = NULL;
Parameters *parameters = NULL;
int         control_type;
double     *gradient   = NULL;

/*Boot module: */
MODULEBOOT();

/*checks on arguments on the matlab side: */
CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&ControlInputSetGradientUsage);

/*Input datasets: */
FetchData((DataSet**)&elements,ELEMENTSIN);
FetchData((DataSet**)&nodes,NODESIN);
FetchData((DataSet**)&vertices,VERTICESIN);
FetchData((DataSet**)&loads,LOADSIN);
FetchData((DataSet**)&materials,MATERIALSIN);
FetchParams(&parameters,PARAMETERSIN);
FetchData(&control_type,CONTROLTYPE);
FetchData(&gradient,NULL,GRADIENT);

/*configure: */
elements->  Configure(elements,loads, nodes,vertices, materials,parameters);
nodes->     Configure(elements,loads, nodes,vertices, materials,parameters);
loads->     Configure(elements, loads, nodes,vertices, materials,parameters);

/*call "x" code layer*/
ControlInputSetGradientx(elements,nodes,vertices,loads, materials,parameters,control_type,gradient);

/*write output datasets: */
WriteData(ELEMENTS,elements);
WriteData(NODES,nodes);
WriteData(VERTICES,vertices);
WriteData(LOADS,loads);
WriteData(MATERIALS,materials);
WriteParams(PARAMETERS,parameters);

/*Free ressources: */
delete elements;
delete nodes;
delete vertices;
delete loads;
delete materials;
delete parameters;

/*end module: */
MODULEEND();
}

void ControlInputSetGradientUsage(void)
{
	_printf_(true,"\n");
	_printf_(true,"   usage: [elements,nodes,vertices,loads,materials,parameters] = %s(elements,nodes,vertices,loads,materials,control_type,gradient);\n",__FUNCT__);
	_printf_(true,"\n");
}
