/*\file ControlInputGetGradient.c
 *\brief: recover velocity ug from inputs
 */

#include "./ControlInputGetGradient.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*input datasets: */
	Elements   *elements   = NULL;
	Nodes      *nodes      = NULL;
	Vertices   *vertices   = NULL;
	Loads      *loads      = NULL;
	Materials  *materials  = NULL;
	Parameters *parameters = NULL;
	int         control_type;
	Vec         gradient   = NULL;

	/* output datasets: elements and loads*/

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&ControlInputGetGradientUsage);
	
	/*Input datasets: */
	FetchData((DataSet**)&elements,ELEMENTSIN);
	FetchData((DataSet**)&nodes,NODES);
	FetchData((DataSet**)&vertices,VERTICES);
	FetchData((DataSet**)&loads,LOADSIN);
	FetchData((DataSet**)&materials,MATERIALS);
	FetchData(&control_type,CONTROLTYPE);

	/*configure: */
	elements->  Configure(elements,loads, nodes,vertices, materials,parameters);
	nodes->     Configure(elements,loads, nodes,vertices, materials,parameters);
	loads->     Configure(elements, loads, nodes,vertices, materials,parameters);

	/*!core code:*/
	ControlInputGetGradientx(&gradient,elements, nodes,vertices,loads, materials,parameters,control_type);

	/*write output datasets: */
	WriteData(GRADIENT,gradient);

	/*Free ressources: */
	delete elements;
	delete nodes;
	delete vertices;
	delete loads;
	delete materials;
	delete parameters;

	/*end module: */
	MODULEEND();
}

void ControlInputGetGradientUsage(void)
{
	_printf_(true,"\n");
	_printf_(true,"   usage: [gradient] = %s(elements,nodes,vertices,loads, materials,parameters,control_type);\n",__FUNCT__);
	_printf_(true,"\n");
}
