/*!\file:  CorePointerFromSolutionEnum.cpp
 * \brief: return type of analyses, number of analyses and core solution function.
 */ 

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "../toolkits/toolkits.h"
#include "../objects/objects.h"
#include "../shared/shared.h"
#include "../EnumDefinitions/EnumDefinitions.h"
#include "./solutions.h"
#include "../modules/modules.h"
#include "../include/include.h"
#include "../solvers/solvers.h"

void AdjointCorePointerFromSolutionEnum(void (**padjointcore)(FemModel*),int solutiontype){

	/*output: */
	void (*adjointcore)(FemModel*)=NULL;

	switch(solutiontype){
	
		case DiagnosticSolutionEnum:
			adjointcore=&adjointdiagnostic_core;
			break;
		case SteadystateSolutionEnum:
			adjointcore=&adjointdiagnostic_core;
			break;
		case BalancedthicknessSolutionEnum:
			adjointcore=&adjointbalancedthickness_core;
			break;
		default:
			_error_("No adjoint has been implemented for solution %s yet",EnumToString(solutiontype));
			break;
	}
	
	/*Assign output pointer:*/
	_assert_(padjointcore);
	*padjointcore=adjointcore;

}
