/*\file SurfaceArea.c
 *\brief: duplicate input
 */

#include "./SurfaceArea.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*input datasets: */
	Elements   *elements   = NULL;
	Nodes      *nodes      = NULL;
	Vertices   *vertices   = NULL;
	Loads      *loads      = NULL;
	Materials  *materials  = NULL;
	Parameters *parameters = NULL;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&SurfaceAreaUsage);

	/*Input datasets: */
	FetchData((DataSet**)&elements,ELEMENTS);
	FetchData((DataSet**)&nodes,NODES);
	FetchData((DataSet**)&vertices,VERTICES);
	FetchData((DataSet**)&loads,LOADS);
	FetchData((DataSet**)&materials,MATERIALS);
	FetchParams(&parameters,PARAMETERS);

	/*configure: */
	elements->  Configure(elements,loads, nodes,vertices, materials,parameters);
	nodes->     Configure(elements,loads, nodes,vertices, materials,parameters);
	loads->     Configure(elements, loads, nodes,vertices, materials,parameters);

	/*!Call core code: */
	SurfaceAreax(NULL,elements, nodes, vertices, loads, materials,parameters);

	/*write output : */
	WriteData(ELEMENTSOUT,elements);

	/*Free ressources: */
	delete elements;
	delete nodes;
	delete vertices;
	delete loads;
	delete materials;
	delete parameters;
	
	/*end module: */
	MODULEEND();

}

void SurfaceAreaUsage(void)
{
	_printf_(true,"\n");
	_printf_(true,"   usage: [elements] = %s(elements, nodes, vertices, loads, materials, parameters);\n",__FUNCT__);
	_printf_(true,"\n");
}
