/*\file Reduceload.c
 *\brief: reduce load from g set to f set
 */

#include "./Reduceload.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*input datasets: */
	Vec         pf         = NULL;
	Mat         Kfs        = NULL;
	Vec         ys         = NULL;
	Parameters *parameters = NULL;
	bool        flag_ys0=false;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	if((nlhs!=NLHS) || (nrhs!=4 && nrhs!=5)){
		ReduceloadUsage();
		_error_(" usage. See above");
	}

	/*Input datasets: */
	FetchData(&pf,PF);
	FetchData(&Kfs,KFS);
	FetchData(&ys,YS);
	FetchParams(&parameters,PARAMETERS);

	/*!Reduce load from g to f size: */
	if(nrhs==5){
		FetchData(&flag_ys0,YSFLAG);
		Reduceloadx(pf, Kfs, ys,parameters,flag_ys0);
	}
	else{
		Reduceloadx(pf, Kfs, ys,parameters);
	}

	/*write output datasets: */
	WriteData(PFOUT,pf);

	/*Free ressources: */
	VecFree(&pf);
	MatFree(&Kfs);
	VecFree(&ys);
	delete parameters;

	MODULEEND();
}

void ReduceloadUsage(void)
{
	_printf_(true,"\n");
	_printf_(true,"   usage: [pf] = %s(pf,Kfs,ys,parameters);\n",__FUNCT__);
	_printf_(true,"          [pf] = %s(pf,Kfs,ys,parameters,ys0_flag);\n",__FUNCT__);
	_printf_(true,"\n");
}
