function md=loadresultsfromdisk(md,filename)
%LOADRESULTSFROMDISK - load results of solution sequence from disk file "filename"            
%
%   Usage:
%      md=loadresultsfromdisk(md,filename);

%We convert all results to m/a units, from m/s

if ((nargin~=2) | (nargout~=1)),
	help loadresultsfromdisk;
	error('loadresultsfromdisk: error message.');
end


results=parseresultsfromdisk(filename);

%First get solution type
analysis_type=results{1};

if ~strcmpi(analysis_type,md.analysis_type),
	error(['loadresultsfromdisk error message: trying  to load results from disk for analysis_type: ',md.analysis_type,' when results are from analysis_type: ',analysis_type]);
end

%Get part
part=results{2};

%now to specialized reading
if strcmpi(analysis_type,'diagnostic'),

	%Get u_g
	u_g=results{3};
	p_g=results{4};

	if strcmpi(md.type,'2d'),
		gsize=md.numberofgrids*2;
		%Used to recover velocities
		indx=1:2:gsize;
		indy=2:2:gsize;
		indx=indx(part);
		indy=indy(part);

		%Recover velocity
		md.vx=u_g(indx)*md.yts;
		md.vy=u_g(indy)*md.yts;
		md.vel=sqrt(md.vx.^2+md.vy.^2);
		md.pressure=p_g(part);
	else
		%Used to recover velocities
		gsize=length(u_g);
		offset=gsize/md.numberofgrids;
		indx=1:offset:gsize;
		indy=2:offset:gsize;
		indz=3:offset:gsize;
		indx=indx(part);
		indy=indy(part);
		indz=indz(part);

		%Recover velocity
		md.vx=u_g(indx)*md.yts;
		md.vy=u_g(indy)*md.yts;
		md.vz=u_g(indz)*md.yts;
		md.vel=sqrt(md.vx.^2+md.vy.^2+md.vz.^2);
		md.pressure=p_g(part);
	end

elseif strcmpi(analysis_type,'control'),

	%Get u_g
	u_g=results{3};
	gsize=length(u_g);

	%Used to recover velocities
	indx=1:2:gsize;
	indy=2:2:gsize;
	indx=indx(part);
	indy=indy(part);

	%Recover velocity
	md.cont_vx=u_g(indx)*md.yts;
	md.cont_vy=u_g(indy)*md.yts;
	md.cont_vel=sqrt(md.cont_vx.^2+md.cont_vy.^2);
	
	%recover parameter 
	cont_parameter=results{4};
	cont_parameter=cont_parameter(indx);
	md.cont_parameter=cont_parameter;
	
	%read J
	if(md.nsteps~=results{5}),
		error('output from control method incompatible with model');
	end
	md.cont_J=results{6};

elseif strcmpi(analysis_type,'thermal'),

	%read results
	time=results{4};
	t_g=results{5};
	m_g=results{6};

	if strcmpi(md.sub_analysis_type,'steady');

		%Recover temperature and melting
		md.temperature=t_g(part);
		md.melting=m_g(part)*md.yts;

	else

		%Recover temperature and melting
		error('not implemented yet')

	end

elseif strcmpi(analysis_type,'prognostic'),

	%read results
	h_g=results{3};
	md.new_thickness=h_g(part);

else
	error(['loadresultsfromdisk error message: unknow solution type ',analysis_type]);
end


%Check result is consistent
disp(sprintf('%s\n','checking result consistency'));

if ~isresultconsistent(md),
	disp('!! results not consistent correct the model !!') %it would be very cruel to put an error, it would kill the computed results (even if not consistent...)
end
