%STARTUP - Matlab startup script
%
%   startup.m is a script run by matlab at the beginning of a session, just before 
%   handing over the prompt to the user. This delivery startup.m script has been customized here for 
%   the ISSM code. This startup script should be run by users before trying to use ISSM. The best way 
%   to do that is to put the startup file in the location where Matlab starts and established its root
%   directory.
%
%   Copyright Jet Propulsion Laboratory. 

global ISSM_TIER  ISSM_DIR
lastwarn(''); % clear the last warning to focus on the warnings of the ISSM path

%Recover ISSM_TIER, ISSM_DIR and USERNAME
if ispc,
	[status1,ISSM_TIER]=system('echo [%ISSM_TIER_WIN%]');
	[status2,ISSM_DIR] =system('echo [%ISSM_DIR_WIN%]');
	[status3,USERNAME] =system('echo [%USER%]');
else
	[status1,ISSM_TIER]=system('echo $ISSM_TIER');
	[status2,ISSM_DIR] =system('echo $ISSM_DIR');
	[status3,USERNAME] =system('echo $USER');
end
if status1~=0, error('startup error message: problem when running ''echo $ISSM_TIER'' shell command'); end
if status2~=0, error('startup error message: problem when running ''echo $ISSM_DIR'' shell command'); end
if status3~=0, error('startup error message: problem when running ''echo $USER'' shell command'); end
clear status1 status2 status3;
if (length(ISSM_TIER)<=1),
	error('issmdir error message: ''ISSM_TIER'' environment variable is empty! You should define ISSM_TIER in your .cshrc or .bashrc!');
end
if (length(ISSM_DIR)<=1),
	error('issmdir error message: ''ISSM_DIR'' environment variable is empty! You should define ISSM_DIR in your .cshrc or .bashrc!');
end

%get rid of useless symbols in the name
ISSM_TIER=strtrim(ISSM_TIER); 
ISSM_DIR =strtrim(ISSM_DIR); 
USERNAME =strtrim(USERNAME);

%Now add all issm code paths necessary to run issm smoothly. 
%We capture the error output, so that we can warn the user to update 
%the variable ISSM_TIER in this file, in case it is not correctly setup. 

%ISSM path
addpath([ISSM_TIER '/src/m/utils/']); %loads genpath_ice
addpath([ISSM_TIER '/etc']);
addpath([ISSM_TIER '/doc']);
addpath([ISSM_TIER '/bin']);
addpath(genpath_ice([ISSM_TIER '/src/m']));
addpath(genpath_ice([ISSM_TIER '/src/pro']));
addpath(genpath_ice([ISSM_TIER '/externalpackages/subplotSpacing']));
addpath(genpath_ice([ISSM_TIER '/externalpackages/scotch']));
rmpath(genpath_ice([ISSM_TIER '/src/m/contrib']));

%Check on any warning messages that might indicate that the paths were not correct. 
if ~isempty(lastwarn),
	fprintf('\n  Error trying to setup ''ISSM'' code paths. Try and update the ISSM_TIER variable in your .cshrc or .bashrc!\n');
	fprintf('  ''ISSM'' will not  work at all until this is resolved\n\n');
else
	fprintf('\n  To get started with ISSM, type issmdoc at the command prompt.\n\n');
end

%  deal with Matlab bug (on Linux, not WinXP) -- unless
%  the class has been called, "empty" method can not be found
normal_uncertain;
continuous_design;
continuous_state;
linear_inequality_constraint;
linear_equality_constraint;
response_function;
objective_function;
least_squares_term;
nonlinear_inequality_constraint;
nonlinear_equality_constraint;
clear ans

%Now, load personal startup preferences, using the local user name: 
if exist([ISSM_TIER '/src/m/contrib/' USERNAME],'dir'),
	addpath(genpath_ice([ISSM_TIER '/src/m/contrib/' USERNAME]));
end
clear USERNAME;
