%VERBOSE class definition
%
%   Usage:
%      verbose=verbose();
%      verbose=verbose(3);
%      verbose=verbose('001100');
%      verbose=verbose('module',true,'solver',false);

%WARNING: some parts of this file are Synchronized with src/c/shared/Numerics/Verbosity.h
%         Do not modify these sections. See src/c/shared/Numerics/README for more info

classdef verbose
	properties (SetAccess=public) 
		% {{{1
		%BEGINFIELDS
		mprocessor=false;
		module=false;
		solution=false;
		solver=false;
		convergence=false;
		control=false;
		qmu=false;
		%ENDFIELDS
		% }}}
	end
	%}}}
	methods
		function verbose=verbose(varargin) % {{{1

			if nargin==1,

				binary=varargin{1};
				if ischar(binary),
					binary=bin2dec(binary);
				end 
				verbose=BinaryToVerbose(verbose,binary);

			else

				options=pairoptions(varargin{:});
				for i=1:size(options.list,1),
					fieldname=options.list{i,1};
					fieldvalue=options.list{i,2};
					if ismember(fieldname,properties(verbose)),
						verbose.(fieldname)=fieldvalue;
					else
						disp(['''' fieldname ''' is not a property of verbose verbose']);
					end
				end

			end
		end
		%}}}
		function binary=VerboseToBinary(verbose) % {{{1

		%BEGINVERB2BIN
		binary=0;
		if (verbose.mprocessor), binary=bitor(binary,1); end
		if (verbose.module), binary=bitor(binary,2); end
		if (verbose.solution), binary=bitor(binary,4); end
		if (verbose.solver), binary=bitor(binary,8); end
		if (verbose.convergence), binary=bitor(binary,16); end
		if (verbose.control), binary=bitor(binary,32); end
		if (verbose.qmu), binary=bitor(binary,64); end
		%ENDVERB2BIN

		end
		%}}}
		function verbose=BinaryToVerbose(verbose,binary) % {{{1

		%BEGINBIN2VERB
		if bitand(binary,1), verbose.mprocessor=true; else verbose.mprocessor=false; end
		if bitand(binary,2), verbose.module=true; else verbose.module=false; end
		if bitand(binary,4), verbose.solution=true; else verbose.solution=false; end
		if bitand(binary,8), verbose.solver=true; else verbose.solver=false; end
		if bitand(binary,16), verbose.convergence=true; else verbose.convergence=false; end
		if bitand(binary,32), verbose.control=true; else verbose.control=false; end
		if bitand(binary,64), verbose.qmu=true; else verbose.qmu=false; end
		%ENDBIN2VERB

		end
		%}}}
		function disp(verbose) % {{{1
			
		%BEGINDISP
		disp(sprintf('class ''%s''  = ',class(verbose)));
		disp(sprintf('   %15s : %s','mprocessor',mat2str(verbose.mprocessor)));
		disp(sprintf('   %15s : %s','module',mat2str(verbose.module)));
		disp(sprintf('   %15s : %s','solution',mat2str(verbose.solution)));
		disp(sprintf('   %15s : %s','solver',mat2str(verbose.solver)));
		disp(sprintf('   %15s : %s','convergence',mat2str(verbose.convergence)));
		disp(sprintf('   %15s : %s','control',mat2str(verbose.control)));
		disp(sprintf('   %15s : %s','qmu',mat2str(verbose.qmu)));
		%ENDDISP

		end
		%}}}
	end
end
