function femmodel=thermal_core(femmodel)
%THERMAL_CORE - core of thermal solution
%
%   Usage:
%      femmodel=thermal_core(femmodel)


	%recover parameters common to all solutions
	ndt=femmodel.parameters.Ndt;
	dt=femmodel.parameters.Dt;
	control_analysis=femmodel.parameters.ControlAnalysis;
	solution_type=femmodel.parameters.SolutionType;

	%Compute number of timesteps
	if (dt==0 | ndt==0),
		dt=0;
		nsteps=1;
	else
		nsteps=floor(ndt/dt);
	end

	%Loop through time
	for i=1:nsteps,
		issmprintf(VerboseSolution,'\n%s%i/%i\n','time step: ',i,nsteps);
		time=(i+1)*dt;

		issmprintf(VerboseSolution,'\n%s',['   computing temperature']);
		femmodel=thermal_core_step(femmodel,i,time); 

		if (solution_type==ThermalSolutionEnum & ~control_analysis),
			issmprintf(VerboseSolution,'\n%s',['   saving results']);
			femmodel.elements=InputToResult(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,TemperatureEnum,i,time);
			femmodel.elements=InputToResult(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,MeltingRateEnum,i,time);
		end
	end

end %end of function
