/*!\file ConfigureObjectsx
 * \brief: configure objects in elements and loads to link in with nodes
 */

#include "./ConfigureObjectsx.h"

#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

int	ConfigureObjectsx( Elements* elements, Loads* loads, Nodes* nodes, Vertices* vertices, Materials* materials,Parameters* parameters){

	/*Intermediary*/
	int noerr=1;
	int i;
	Element* element=NULL;
	Load* load=NULL;
	Node* node=NULL;
	Material* material=NULL;
	int configuration_type;

	/*Get analysis type: */
	parameters->FindParam(&configuration_type,ConfigurationTypeEnum);
	
	ISSMPRINTF(VerboseMProcessor(),"      Configuring elements...\n");
	for (i=0;i<elements->Size();i++){
		element=(Element*)elements->GetObjectByOffset(i);
		element->Configure(elements,loads,nodes,materials,parameters);
	}
	ISSMPRINTF(VerboseMProcessor(),"      Configuring loads...\n");
	for (i=0;i<loads->Size();i++){
		load=(Load*)loads->GetObjectByOffset(i);
		if (load->InAnalysis(configuration_type)){
			load->Configure(elements,loads,nodes,vertices,materials,parameters);
		}
	}
	ISSMPRINTF(VerboseMProcessor(),"      Configuring nodes...\n");
	for (i=0;i<nodes->Size();i++){
		node=(Node*)nodes->GetObjectByOffset(i);
		if(node->InAnalysis(configuration_type)){
			node->Configure(nodes,vertices);
		}
	}
	
	ISSMPRINTF(VerboseMProcessor(),"      Configuring materials...\n");
	for (i=0;i<materials->Size();i++){
		material=(Material*)materials->GetObjectByOffset(i);
		material->Configure(elements);
	}
	return noerr;
}
