function femmodel=surfaceslope_core(femmodel)
%SURFACESLOPE_CORE - core of the surface slope computation solution
%
%   Usage:
%      femmodel=surfaceslope_core(femmodel)
%

	%Recover some parameters:
	dim=femmodel.parameters.Dim;
	control_analysis=femmodel.parameters.ControlAnalysis;
	solution_type=femmodel.parameters.SolutionType;

	%Call on core computations: 
	issmprintf(VerboseSolution,'\n%s',['   computing surface slope']);
	femmodel=SetCurrentConfiguration(femmodel,SurfaceSlopeAnalysisEnum,SurfaceSlopeXAnalysisEnum);
	femmodel=solver_linear(femmodel);
	femmodel=SetCurrentConfiguration(femmodel,SurfaceSlopeAnalysisEnum,SurfaceSlopeYAnalysisEnum);
	femmodel=solver_linear(femmodel);
	
	if (solution_type==SurfaceSlopeSolutionEnum),
		issmprintf(VerboseSolution,'\n%s',['   saving results']);
		femmodel.elements=InputToResult(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,SurfaceSlopeXEnum);
		femmodel.elements=InputToResult(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,SurfaceSlopeYEnum);
	end

end %end function
