function femmodel=prognostic_core(femmodel)
%PROGNOSTIC_CORE - linear solution sequence
%
%   Usage:
%      femmodel=prognostic_core(femmodel)

	%recover parameters common to all solutions
	control_analysis=femmodel.parameters.ControlAnalysis;
	solution_type=femmodel.parameters.SolutionType;

	%Activate formulation
	femmodel=SetCurrentConfiguration(femmodel,PrognosticAnalysisEnum);

	issmprintf(VerboseSolution,'\n%s',['   call computational core']);
	femmodel=solver_linear(femmodel);
	
	if (solution_type==PrognosticSolutionEnum & ~control_analysis)
		issmprintf(VerboseSolution,'\n%s',['   saving results']);
		femmodel.elements=InputToResult(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,ThicknessEnum);
	end

end %end function
