function convergence=controlconvergence(J,responses,eps_cm,n)
%CONTROLCONVERGENCE - determine the convergence of control_core solution
%
%   Usage:
%       converged=controlconvergence(J,responses,eps_cm,n);

	convergence=false;
	if ~isnan(eps_cm),
		i=n-2;
		%go through the previous responsess(starting from n-2)
		while (i>=1),
			if (strcmp(responses(i),responses(n))),
				%convergence test only if we have the same misfits
				if ((J(i)-J(n))/J(n) <= eps_cm),
					%convergence if convergence criteria fullfilled
					convergence=true;
					issmprintf(VerboseConvergence(),'\n%s%g%s%g\n','      Convergence criterion: dJ/J = ',(J(i)-J(n))/J(n),'<',eps_cm);
				else
					issmprintf(VerboseConvergence(),'\n%s%g%s%g\n','      Convergence criterion: dJ/J = ',(J(i)-J(n))/J(n),'>',eps_cm);
				end
				break;
			end
			i=i-1;                                                                                                                                         
		end
	end

end %end function
