/*!\file: prognostic_core.cpp
 * \brief: core of the prognostic solution 
 */ 

#include "../toolkits/toolkits.h"
#include "../objects/objects.h"
#include "../shared/shared.h"
#include "../EnumDefinitions/EnumDefinitions.h"
#include "./solutions.h"
#include "../modules/modules.h"
#include "../solvers/solvers.h"

void prognostic_core(FemModel* femmodel){

	/*parameters: */
	int solution_type;
	bool control_analysis;

	/*activate formulation: */
	femmodel->SetCurrentConfiguration(PrognosticAnalysisEnum);
	
	/*recover parameters: */
	femmodel->parameters->FindParam(&control_analysis,ControlAnalysisEnum);
	femmodel->parameters->FindParam(&solution_type,SolutionTypeEnum);

	ISSMPRINTF(VerboseSolution(),"   call computational core\n");
	solver_linear(femmodel);
		
	if(solution_type==PrognosticSolutionEnum && !control_analysis){
		ISSMPRINTF(VerboseSolution(),"   saving results\n");
		InputToResultx(femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters,ThicknessEnum);
	}
	
}

