/*!\file: thermal_core_step.cpp
 * \brief: core of the thermal solution 
 */ 

#include "../toolkits/toolkits.h"
#include "../objects/objects.h"
#include "../shared/shared.h"
#include "../EnumDefinitions/EnumDefinitions.h"
#include "./solutions.h"
#include "../modules/modules.h"
#include "../include/include.h"
#include "../solvers/solvers.h"

void thermal_core_step(FemModel* femmodel,int step, double time){

	ISSMPRINTF(VerboseSolution(),"   computing temperatures\n");
	femmodel->SetCurrentConfiguration(ThermalAnalysisEnum);
	solver_thermal_nonlinear(femmodel);

	ISSMPRINTF(VerboseSolution(),"   computing melting\n");
	femmodel->SetCurrentConfiguration(MeltingAnalysisEnum);
	solver_linear(femmodel);
}
