/*!\file: ResetBoundaryConditions.cpp
 * \brief: change boundary conditions of a model, using a solution vector from another analysis
 */ 

#include "../objects/objects.h"
#include "../modules/modules.h"
#include "../EnumDefinitions/EnumDefinitions.h"

void ResetBoundaryConditions(FemModel* femmodel, int analysis_type){
	
	Vec yg=NULL;
	Vec ys=NULL;
	int analysis_counter;
			
	ISSMPRINTF(VerboseSolution(),"%s\n","   updating boundary conditions...");
			
	/*set current analysis: */
	femmodel->SetCurrentConfiguration(analysis_type);

	GetSolutionFromInputsx( &yg, femmodel->elements,femmodel->nodes, femmodel->vertices,femmodel->loads, femmodel->materials,  femmodel->parameters);

	/*For this analysis_type, free existing boundary condition vector: */
	analysis_counter=femmodel->analysis_counter;
	VecFree(&femmodel->m_ys[analysis_counter]);

	//Reduce from g to s set
	Reducevectorgtosx(&ys,yg,femmodel->m_nodesets[analysis_counter],femmodel->parameters);

	/*Plug into femmodel->m_ys: */
	femmodel->m_ys[analysis_counter]=ys;

	/*Free ressources:*/
	VecFree(&yg);
}
