/*!\file Reducematrixfromgtofx
 * \brief reduce matrix from g set to f fset
 */
#include "./Reducematrixfromgtofx.h"

void Reducematrixfromgtofx( Mat* pKff, Mat* pKfs,Mat Kgg,NodeSets* nodesets,Parameters* parameters){

	/*output: */
	Mat Kff=NULL;
	Mat Kfs=NULL;

	/*Display message*/
	ISSMPRINTF(VerboseModule(),"   Reducing Stiffness Matrix from gset to fset\n");

	//Reduce matrix from g-size to f-size
	if(nodesets->GetSSize()){

		if(nodesets->GetFSize()){
			MatPartition(&Kff, Kgg, nodesets->GetPV_F(),nodesets->GetFSize(),nodesets->GetPV_F(),nodesets->GetFSize()); 
			MatPartition(&Kfs, Kgg, nodesets->GetPV_F(),nodesets->GetFSize(),nodesets->GetPV_S(),nodesets->GetSSize()); 
		}
	}
	else{
		MatDuplicate(Kgg,MAT_COPY_VALUES,&Kff);
		Kfs=NULL;
	}

	/*Assign output pointers:*/
	*pKff=Kff;
	*pKfs=Kfs;
}
