/*!\file PenaltyConstraintsx
 * \brief: set up penalty constraints on loads
 */

#include "./PenaltyConstraintsx.h"
#include "./PenaltyConstraintsLocal.h"
#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

void PenaltyConstraintsx(int* pconverged, int* pnum_unstable_constraints, Elements* elements,Nodes* nodes, Vertices* vertices, Loads* loads,Materials* materials,  Parameters* parameters){

	int i;

	extern int num_procs;
	extern int my_rank;
	
	/*output: */
	int converged=0;
	int num_unstable_constraints=0;
	int min_mechanical_constraints=0; 
	int analysis_type;

	/*Display message*/
	ISSMPRINTF(VerboseModule(),"   Constraining penalties\n");

	/*recover parameters: */
	parameters->FindParam(&min_mechanical_constraints,MinMechanicalConstraintsEnum);
	parameters->FindParam(&analysis_type,AnalysisTypeEnum);

	/*Do we have penalties linked to rifts? In this case, run our special rifts penalty 
	 * management routine, otherwise, skip : */
	if (RiftIsPresent(loads,analysis_type)){
		RiftConstraints(&converged,&num_unstable_constraints,loads,min_mechanical_constraints,analysis_type);
	}
	else if(MeltingIsPresent(loads,analysis_type)){
		MeltingConstraints(loads,&converged,&num_unstable_constraints,analysis_type);
	}
	else{
		/*Do nothing, no constraints management!:*/
		num_unstable_constraints=0;
		converged=1;
	}
		
	/*Assign output pointers: */
	*pconverged=converged;
	*pnum_unstable_constraints=num_unstable_constraints;
}
