function femmodel=solver_adjoint_linear(femmodel)
%SOLVER_LINEAR - core solver of any linear solution sequence
%
%   Usage:
%      femmodel =solver_adjoint_linear(femmodel)

	%Get parameters
	kffpartitioning=femmodel.parameters.Kff;

	if kffpartitioning,
		[K_gg,K_ff,K_fs,p_g,p_f,kmax]=SystemMatrices(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters);
		p_f = Reduceload( p_f, K_fs, femmodel.ys,femmodel.parameters,true);
	else
		[K_gg,K_ff,K_fs,p_g,p_f,kmax]=SystemMatrices(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters);
		[K_ff, K_fs] = Reducematrixfromgtof( K_gg, femmodel.nodesets,femmodel.parameters); 
		p_f = Reduceloadfromgtof( p_g, K_fs, femmodel.ys, femmodel.nodesets,femmodel.parameters,true);
	end

	issmprintf(femmodel.parameters.Verbose>1,'%s%g','      condition number of stiffness matrix: ',condest(K_ff));
	u_f=Solver(K_ff,p_f,[],femmodel.parameters);
	u_g= Mergesolutionfromftog( u_f, femmodel.ys, femmodel.nodesets,femmodel.parameters,true); 

	[femmodel.elements,femmodel.materials]=InputUpdateFromSolution(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,u_g);
