function femmodel=balancedvelocities_core(femmdoel)
%BALANCEDVELOCITIES_CORE - linear solution sequence
%
%   Usage:
%      femmodel=balancedvelocities_core(femmodel)

	%recover parameters common to all solutions
	verbose=femmodel.parameters.Verbose;
	dim=femmodel.parameters.Dim;
	control_analysis=femmodel.parameters.ControlAnalysis;
	solution_type=femmodel.parameters.SolutionType;

	%Activate formulation
	femmodel=SetCurrentConfiguration(femmodel,BalancedvelocitiesAnalysisEnum);

	issmprintf(verbose,'\n%s',['call computational core...']);
	femmodel=solver_linear(femmodel);
	
	if (solution_type==BalancedvelocitiesSolutionEnum & ~control_analysis),
		issmprintf(verbose,'\n%s',['saving results...']);
		femmodel.elements=InputToResult(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,VelEnum);
	end

end %end function
