function femmodel=transient3d_core(femmodel)
%TRANSIENT3D_CORE - core of transient 2d solution
%
%   Usage:
%      femmodel=transient3d_core(femmodel)

	%recover parameters common to all solutions
	verbose=femmodel.parameters.Verbose;
	ndt=femmodel.parameters.Ndt;
	dt=femmodel.parameters.Dt;
	yts=femmodel.parameters.Yts;
	control_analysis=femmodel.parameters.ControlAnalysis;
	solution_type=femmodel.parameters.SolutionType;
	output_frequency=femmodel.parameters.OutputFrequency;
	time_adapt=femmodel.parameters.TimeAdapt;

	%Initialize
	time=0;
	step=0;

	%Loop through time
	while (time < ndt - (yts*eps)),

		%Increment
		if(time_adapt) dt=TimeAdapt(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters); end
		step=step+1;
		time=time+dt;

		issmprintf(verbose,'\n%s%g%s%i%s%g\n','time [yr] ',time,' iteration number: ',step,'/',floor(ndt/dt));

		issmprintf(verbose,'\n%s',['computing temperature...']);
		femmodel=thermal_core_step(femmodel); 

		issmprintf(verbose,'\n%s',['computing new velocities...']);
		femmodel=diagnostic_core(femmodel); 

		issmprintf(verbose,'\n%s',['computing new thickness...']);
		femmodel=prognostic_core(femmodel); 

		issmprintf(verbose,'\n%s',['updating geometry...']);
		[femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters]=UpdateGeometry(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters);

		issmprintf(verbose,'\n%s',['updating vertices position...']);
		[femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters]=UpdateVertexPositions(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters);

		if (solution_type==Transient3DSolutionEnum & ~control_analysis & mod(step,output_frequency)==0),
			issmprintf(verbose,'\n%s',['saving results...']);
			femmodel.elements=InputToResult(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,VxEnum,step,time);
			femmodel.elements=InputToResult(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,VyEnum,step,time);
			femmodel.elements=InputToResult(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,VzEnum,step,time);
			femmodel.elements=InputToResult(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,VelEnum,step,time);
			femmodel.elements=InputToResult(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,PressureEnum,step,time);
			femmodel.elements=InputToResult(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,ThicknessEnum,step,time);
			femmodel.elements=InputToResult(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,SurfaceEnum,step,time);
			femmodel.elements=InputToResult(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,BedEnum,step,time);
			femmodel.elements=InputToResult(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,TemperatureEnum,step,time);
			femmodel.elements=InputToResult(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,MeltingRateEnum,step,time);
		end
	end
end %end of function
