%VERBOSE class definition
%
%   Usage:
%      verbose=verbose();
%      verbose=verbose(3);
%      verbose=verbose('001100');
%      verbose=verbose('module',true,'solver',false);

%WARNING: some parts of this file are Synchronized with src/c/shared/Numerics/Verbosity.h
%         Do not modify these sections. See src/c/shared/Numerics/README for more info

classdef verbose
	properties (SetAccess=public) 
		% {{{1
		%BEGINFIELDS
		module=false;
		convergence=false;
		mprocessor=false;
		solver=false;
		%ENDFIELDS
		% }}}
	end
	%}}}
	methods
		function verbose=verbose(varargin) % {{{1

			if nargin==1,

				binary=varargin{1};
				if ischar(binary),
					binary=bin2dec(binary);
				end 
				verbose=BinaryToVerbose(verbose,binary);

			else

				options=pairoptions(varargin{:});
				for i=1:size(options.list,1),
					fieldname=options.list{i,1};
					fieldvalue=options.list{i,2};
					if ismember(fieldname,properties(verbose)),
						verbose.(fieldname)=fieldvalue;
					else
						disp(['''' fieldname ''' is not a property of verbose verbose']);
					end
				end

			end
		end
		%}}}
		function binary=VerboseToBinary(verbose) % {{{1

		%BEGINVERB2BIN
		binary=0;
		if (verbose.module), binary=bitor(binary,1); end
		if (verbose.convergence), binary=bitor(binary,2); end
		if (verbose.mprocessor), binary=bitor(binary,4); end
		if (verbose.solver), binary=bitor(binary,8); end
		%ENDVERB2BIN

		end
		%}}}
		function verbose=BinaryToVerbose(verbose,binary) % {{{1

		%BEGINBIN2VERB
		if bitand(binary,1), verbose.module=true; else verbose.module=false; end
		if bitand(binary,2), verbose.convergence=true; else verbose.convergence=false; end
		if bitand(binary,4), verbose.mprocessor=true; else verbose.mprocessor=false; end
		if bitand(binary,8), verbose.solver=true; else verbose.solver=false; end
		%ENDBIN2VERB

		end
		%}}}
		function disp(verbose) % {{{1
			
		%BEGINDISP
		disp(sprintf('class ''%s''  = ',class(verbose)));
		disp(sprintf('   %10s : %s','module',mat2str(verbose.module)));
		disp(sprintf('   %10s : %s','convergence',mat2str(verbose.convergence)));
		disp(sprintf('   %10s : %s','mprocessor',mat2str(verbose.mprocessor)));
		disp(sprintf('   %10s : %s','solver',mat2str(verbose.solver)));
		%ENDDISP

		end
		%}}}
	end
end
