/*
* \file Verbosity.cpp:
* \brief: Manage verbosity levels
*
*   WARNING: DO NOT MODIFY THIS FILE
*            this file has been automatically generated by Synchronize.sh
*            Please read README for more information
*/

/*include*/
/*{{{*/
#ifdef HAVE_CONFIG_H
   #include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif
#include "./Verbosity.h"
#include "../../include/macros.h"
#include "../Exceptions/exceptions.h"
#ifdef _SERIAL_
#include <mex.h>
#endif
/*}}}*/

/*Verbosityt levels*/
bool VerboseModule(void){return (GetVerbosityLevel() & 1);} /* 2^0*/
bool VerboseConvergence(void){return (GetVerbosityLevel() & 2);} /* 2^1*/
bool VerboseMProcessor(void){return (GetVerbosityLevel() & 4);} /* 2^2*/
bool VerboseSolver(void){return (GetVerbosityLevel() & 8);} /* 2^3*/

/*Verbosity Setup*/
static int verbositylevel=-1;
/*FUNCTION SetVerbosityLevel {{{*/
void SetVerbosityLevel(int level){

	if(level<0) ISSMERROR("vebosity level should be a positive integer (user provided %i)",level);

#ifdef _SERIAL_

	mxArray* output=NULL;
	mxArray* input=NULL;
	input=mxCreateDoubleScalar((double)level);

	mexCallMATLAB(0,&output,1,&input,"SetVerbosityLevel");
#else

	verbositylevel = level;

#endif
}/*}}}*/
/*FUNCTION GetVerbosityLevel {{{*/
int  GetVerbosityLevel(void){
#ifdef _SERIAL_

	mxArray* output=NULL;
	mxArray* input=NULL;
	double   level;

	mexCallMATLAB(1,&output,0,&input,"GetVerbosityLevel");
	level=mxGetScalar(output);

	verbositylevel = (int)level;

#else

	ISSMASSERT(verbositylevel>=0);
	return verbositylevel;

#endif
}/*}}}*/
