%EISMINT benchmark experiment A
numlayers=10;
resolution=40000;

%To begin with the numerical model
md=mesh(model,'../Exp/SquareEISMINT750000.exp',resolution);
md=geography(md,'','');
md=parameterize(md,'../Par/RoundSheetEISMINT.par');

%We extrude the model to have a 3d model
md=extrude(md,numlayers,1);
md=setelementstype(md,'hutter','all');

%Spc the grids on the bed
pos=find(md.gridonbed);
md.spcvelocity(pos,1:3)=1;

%Adapt the time steps to the resolution
md.dt=20;
md.output_frequency=20;
md.ndt=200000;
md.artificial_diffusivity=2;

%Now we can solve the problem 
md=solve(md,'analysis_type',Transient3DSolutionEnum);

%Fields and tolerances to track changes
field_names     ={'Vx','Vy','Vz','Vel','Pressure','Thickness','Bed','Surface','Temperature','MeltingRate'};
field_tolerances={1e-08,1e-08,1e-08,1e-08,1e-08,1e-08,1e-08,1e-08,1e-08,1e-08};
field_values={...
	PatchToVec(md.results.Transient3DSolution(end).Vx),...
	PatchToVec(md.results.Transient3DSolution(end).Vy),...
	PatchToVec(md.results.Transient3DSolution(end).Vz),...
	PatchToVec(md.results.Transient3DSolution(end).Vel),...
	PatchToVec(md.results.Transient3DSolution(end).Pressure),...
	PatchToVec(md.results.Transient3DSolution(end).Thickness),...
	PatchToVec(md.results.Transient3DSolution(end).Bed),...
	PatchToVec(md.results.Transient3DSolution(end).Surface),...
	PatchToVec(md.results.Transient3DSolution(end).Temperature),...
	PatchToVec(md.results.Transient3DSolution(end).MeltingRate),...
	};
