function md=solveparallel(md,options)
%SOLVEPARALLEL - solution sequence using a cluster in parallel mode
%
%   Usage:
%      md=solveparallel(md);

%retrieve cluster: otherwise, we can't call its methods (subsref bug)
cluster=md.cluster;

%First, build a runtime name that is unique, that we will use to create 
%directories, name jobs, etc ...
c=clock; md.runtimename=sprintf('%s-%i-%i-%i-%i-%i-%i-%i',md.name,c(2),c(3),c(1),c(4),c(5),floor(c(6)),GetPId());

%Marshall model data into a binary file.
marshall(md);

%add qmu fields to binary file if running qmu analysis
if md.qmu_analysis,
	qmumarshall(md,md.variables(options.ivar),md.responses(options.iresp));
end

%Now, we need to build the queuing script, used by the cluster to launch the job.
cluster.BuildQueueScript(md);

%Now, launch the queueing script
cluster.LaunchQueueJob(md,options);

if ~strcmpi(options.upload,'on'), %did we even try to run? if so, wait on lock

	%Do we return, or just wait for results?
	if (md.waitonlock~=0 &  ~strcmpi(options.batch,'yes')),
		%we wait for the done file
		islock=waitonlock(md);
		if islock==0,
			%no results to be loaded
			disp('The results must be loaded manually with md=loadresultsfromcluster(md).');
		else
			%load results
			disp('loading results from cluster');
			md=loadresultsfromcluster(md);
		end
	end

	%post processes qmu results if necessary
	if md.qmu_analysis,
		system(['rm -rf qmu' num2str(GetPId)]);
	end
else
	error('solveparallel done uploading test decks');
end
