%VERBOSE class definition
%
%   Usage:
%      verbose=verbose();
%      verbose=verbose(3);
%      verbose=verbose('001100');
%      verbose=verbose('module',true,'solver',false);

classdef verbose
    properties (SetAccess=public) 
		 % {{{1
		 module=false;
		 convergence=false;
		 modelprocessor=false;
		 solver=false;
		 % }}}
	 end
	 %}}}
	 methods
		 function verbose=verbose(varargin) % {{{1

			 if nargin==1,

				 binary=varargin{1};
				 if ischar(binary),
					 binary=bin2dec(binary);
				 end 
				 verbose=BinaryToVerbose(verbose,binary);

			 else

				 options=pairoptions(varargin{:});
				 for i=1:size(options.list,1),
					 fieldname=options.list{i,1};
					 fieldvalue=options.list{i,2};
					 if ismember(fieldname,properties(verbose)),
						 verbose.(fieldname)=fieldvalue;
					 else
						 disp(['''' fieldname ''' is not a property of verbose verbose']);
					 end
				 end

			 end
		 end
		 %}}}
		 function binary=VerboseToBinary(verbose) % {{{1

			 %WARNING: Must be synchronized with src/c/shared/Numerics/Verbosity.cpp

			 binary=0;
			 if (verbose.module),         binary=bitor(binary,1); end
			 if (verbose.convergence),    binary=bitor(binary,2); end
			 if (verbose.modelprocessor), binary=bitor(binary,4); end
			 if (verbose.solver),         binary=bitor(binary,8); end

		 end
		 %}}}
		 function verbose=BinaryToVerbose(verbose,binary) % {{{1

			 %WARNING: Must be synchronized with src/c/shared/Numerics/Verbosity.cpp

			 if bitand(binary,1), verbose.module=true;         else verbose.module=false;         end
			 if bitand(binary,2), verbose.convergence=true;    else verbose.convergence=false;    end
			 if bitand(binary,4), verbose.modelprocessor=true; else verbose.modelprocessor=false; end
			 if bitand(binary,8), verbose.solver=true;         else verbose.solver=false;         end

		 end
		 %}}}
		 function disp(verbose) % {{{1
			 %  display the object
			 disp(sprintf('class ''%s''  = ',class(verbose)));
			 disp(sprintf('    module        : %s',mat2str(verbose.module)));
			 disp(sprintf('    convergence   : %s',mat2str(verbose.convergence)));
			 disp(sprintf('    modelprocessor: %s',mat2str(verbose.modelprocessor)));
			 disp(sprintf('    solver        : %s',mat2str(verbose.solver)));
		 end
		 %}}}
	end
end
