#!/bin/bash
#Synchronize Verbosity
#first remove existing files
rm $ISSM_TIER/src/m/shared/Verb*.m

echo "Synchronizing Verbosity levels..."

#Get all lines of Verbosity.cpp
cat Verbosity.cpp | grep "bool" | grep "GetVerbosityLevel()" | awk '{ printf "%s %s\n", NR, $0 }' > temp

#get number of lines in temp
NUMBEROFLINES=$(wc -l temp | awk '{printf("%s",$1);}');

# go through the lines of temp
for (( i=1 ; i<=$NUMBEROFLINES ; i++ )); do

	#Get name of the line i
	FILENAME=$(cat temp | grep "^[ ]*$i " | awk '{printf("%s",$3);}');
	ENUM=$(cat temp | grep "^[ ]*$i " | awk '{printf("%s",$7);}');

	#Add Verbosity Matlab file{{{
	cat <<END > $ISSM_TIER"/src/m/shared/"$(echo $FILENAME".m")
function bool=$(echo $FILENAME)()
%$(echo $FILENAME | awk {'print toupper($1)'}) - Enum of $(echo $NAME)
%
%   WARNING: DO NOT MODIFY THIS FILE
%            this file has been automatically generated by src/c/shared/Numerics/Synchronize.sh
%            Please read src/c/shared/Numerics/README for more information
%
%   Usage:
%      bool=$FILENAME()

bool=logical(bitand(GetVerbosityLevel(),$ENUM));
END
#}}}

done
#clean up{{{
rm temp
#}}}
