
/*include*/
/*{{{1*/
#ifdef HAVE_CONFIG_H
   #include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif
#include "./Verbosity.h"
#include "../../include/macros.h"
#include "../Exceptions/exceptions.h"
#ifdef _SERIAL_
#include <mex.h>
#endif
/*}}}*/

/*Verbosityt levels*/
bool VerbModule   (void){return (GetVerbosityLevel() & 1 );}/* 2^0 -> 000000001*/
bool VerbConverge (void){return (GetVerbosityLevel() & 2 );}/* 2^1 -> 000000010*/
bool VerbModProc  (void){return (GetVerbosityLevel() & 4 );}/* 2^2 -> 000000100*/
bool VerbSolver   (void){return (GetVerbosityLevel() & 8 );}/* 2^3 -> 000001000*/

/*Verbosity Setup*/
static int verbositylevel=-1;
/*FUNCTION SetVerbosityLevel {{{1*/
void SetVerbosityLevel(int level){

	if(level<0) ISSMERROR("vebosity level should be a positive integer (user provided %i)",level);

#ifdef _SERIAL_

	mxArray* output=NULL;
	mxArray* input=NULL;
	input=mxCreateDoubleScalar((double)level);

	mexCallMATLAB(0,&output,1,&input,"SetVerbosityLevel");
#else

	verbositylevel = level;

#endif

}/*}}}*/
/*FUNCTION GetVerbosityLevel {{{1*/
int  GetVerbosityLevel(void){

#ifdef _SERIAL_

	mxArray* output=NULL;
	mxArray* input=NULL;
	double   level;

	mexCallMATLAB(1,&output,0,&input,"GetVerbosityLevel");
	level=mxGetScalar(output);

	verbositylevel = (int)level;

#else

	ISSMASSERT(verbositylevel>=0);
	return verbositylevel;

#endif
}/*}}}*/
