function level=GetVerbosityLevel(level_in)
%GETVERBOSITYLEVEL - get verbosity level
%
%   Usage:
%      level=GetVerbosityLevel();

persistent verbositylevel;

if nargin==1 & nargout==0,
	verbositylevel=level_in;
elseif nargin==0 & nargout==1,
	if isempty(verbositylevel), error('verbositylevel has not been set. Call SetVerbositylevel first!'); end
	level=verbositylevel;
else
	help GetVerbosityLevel
	error('Bad usage');
end
