function plot_quiver(md,options,nlines,ncols,index);
%PLOT_QUIVER - quiver plot with colors
%
%   to be perfected tomorrow
%
%   Usage:
%      plot_quiver(x,y,u,v,options)
%
%   Example:
%      plot_quiver(md.x,md.y,md.vx,md.vy,options);

%prepare plot
subplot(nlines,ncols,index); 
hold on

fields=getfieldvalue(options,'quiver_field',{'vx','vy'});

%call fields vx and vy, for ease of use
if ischar(fields{1}), vx=md.(fields{1}); else vx=fields{1}; end
if ischar(fields{2}), vy=md.(fields{2}); else vy=fields{2}; end

%process fields
[quivers,palette]=quiver_process(md.x,md.y,vx,vy,options);

%loop over the number of colors
hold on
h=[];
for i=1:quivers.numcolors
	pos=find(quivers.colorind==i);
	hprime=quiver(quivers.x(pos),quivers.y(pos),quivers.u(pos),quivers.v(pos),...
		'Color',palette(i,:),'ShowArrowHead','on','AutoScale','off');
	h=[h;hprime];
end

%take care of colorbar
quiver_colorbar(quivers,options);


%apply options
options=addfielddefault(options,'title','Quiver plot.');
options=addfielddefault(options,'colorbar',1);
applyoptions(md,[],options);
