#!/bin/bash

#Get number of cpus
NUMCPUS=$1;

#version of gdal
version=`echo *.tar.gz | sed 's/\.tar\.gz//g' | sed 's/gdal-//g'`

#Some cleanup
rm -rf src
rm -rf install
rm -rf gdal-$version

#Create src and install directories
mkdir src install

#Untar 
tar -zxvf  gdal-$version.tar.gz

#Move gdal into src directory
mv gdal-$version/* src
rm -rf gdal-$version

#Configure gdal
cd src
./configure --prefix="$ISSM_TIER/externalpackages/gdal/install" --without-python --with-netcdf=no --with-jasper=no --without-ld-shared --with-unix-stdio-64=no --with-expat-lib=/usr/lib64/libexpat.so

#Patch GDALmake.opt
patch GDALmake.opt ../GDALmake.opt.patch


#Compile and install gdal
if [ -z $NUMCPUS ];
then
	make
	make install
else
	make -j $NUMCPUS
	make install
fi
