/*!\file: numerics.h
 * \brief prototypes for numerics.h
 */ 

#ifndef _NUMERICS_H_
#define  _NUMERICS_H_

#include "./Verbosity.h"
#include "./GaussPoints.h"
#include "./isnan.h"

class Input;
class Parameters;

struct OptArgs;
struct OptPars;

double min(double a,double b);
double max(double a,double b);
double OptFunc(double scalar, OptArgs* optargs);
void   BrentSearch(double* psearch_scalar,double* pJ,OptPars* optpars,double (*f)(double,OptArgs*), OptArgs* optargs);
void   OptimalSearch(double* psearch_scalar,double* pJ,OptPars* optpars,double (*f)(double,OptArgs*), OptArgs* optargs);
void   cross(double* result,double* vector1,double* vector2);
double norm(double* vector);
void IsInputConverged(double* peps, Input** new_inputs,Input** old_inputs,int num_inputs,int criterion_enum);
void UnitConversion(double* values, int numvalues,int direction_enum, int type_enum, Parameters* parameters);
double UnitConversion(double value, int direction_enum, int type_enum, Parameters* parameters);
void PetscOptionsFromAnalysis(Parameters* parameters,int analysis_type);

#endif //ifndef _NUMERICS_H_

