md=mesh(model,'../Exp/Pig.exp',100000);
md=geography(md,'../Exp/PigShelves.exp','../Exp/PigIslands.exp');
md=parameterize(md,'../Par/Pig.par');
md=extrude(md,3,1);
md=setelementstype(md,'pattyn','all');
md.artificial_diffusivity=2;
md=SetParallel(md,3);
md.dt=0;
md.min_thermal_constraints=40;
md=solve(md,'analysis_type',ThermalSolutionEnum);

%Fields and tolerances to track changes
field_names     ={'Temperature','MeltingRate'};
field_tolerances={1e-13,1e-13};
field_values={...
	PatchToVec(md.results.ThermalSolution.Temperature),...
	PatchToVec(md.results.ThermalSolution.MeltingRate),...
	};
