md=mesh(model,'../Exp/79North.exp',10000);
md=meshconvert(md);
md=geography(md,'../Exp/79NorthShelf.exp','');
md=parameterize(md,'../Par/79North.par');
md=setelementstype(md,'macayeal','all');

%Ice sheet only
md=modelextract(md,md.elementonicesheet);
pos=find(md.gridonboundary);
md.spcthickness(pos,1)=1;
md.spcthickness(:,2)=md.thickness;

%control parameters
md.thickness_obs=md.thickness;
md.control_analysis=1;
md.thickness_obs=md.thickness;
md.nsteps=2;
md.control_type=[VxEnum() VyEnum()];
md.prognostic_DG=0;
md.optscal=[10/md.yts*ones(md.nsteps,1) 10/md.yts*ones(md.nsteps,1)];
md.cm_min=[-2000 -2000]'/md.yts;
md.cm_max=[+2000 +2000]'/md.yts;
md.cm_responses=ThicknessAbsMisfitEnum*ones(md.nsteps,1);
md.weights=ones(md.numberofgrids,1);
md.maxiter=4*ones(md.nsteps,1);
md.cm_jump=0.99*ones(md.nsteps,1);

md.cluster=none;
md=solve(md,'analysis_type',BalancedthicknessSolutionEnum);

%Fields and tolerances to track changes
field_names     ={'Gradient1' 'Gradient2' 'Misfits' 'Vx' 'Vy' 'Thickness'};
field_tolerances={1e-12,1e-12,1e-12,1e-12,1e-12,1e-12};
field_values={...
	PatchToVec(md.results.BalancedthicknessSolution.Gradient1),...
	PatchToVec(md.results.BalancedthicknessSolution.Gradient2),...
	md.results.BalancedthicknessSolution.J,...
	PatchToVec(md.results.BalancedthicknessSolution.Vx),...
	PatchToVec(md.results.BalancedthicknessSolution.Vy),...
	PatchToVec(md.results.BalancedthicknessSolution.Thickness)
};
