md=mesh(model,'../Exp/Square.exp',200000);
md=geography(md,'','');
md=parameterize(md,'../Par/SquareSheetConstrained.par');
md=extrude(md,3,1);
md=setelementstype(md,'stokes','all');

%control parameters
md.control_analysis=1;
md.control_type=DragCoefficientEnum();
md.cm_min=1;
md.cm_max=200;
md.nsteps=2;
md.cm_responses=SurfaceLogVxVyMisfitEnum()*ones(md.nsteps,1);
md.weights=ones(md.numberofgrids,1);
md.optscal=3*ones(md.nsteps,1);
md.maxiter=2*ones(md.nsteps,1);
md.cm_jump=0.3*ones(md.nsteps,1);
md.cm_noisedmp=2*10^-7;
md.vx_obs=md.vx; md.vy_obs=md.vy;

md=SetParallel(md,3);
md=solve(md,'analysis_type',DiagnosticSolutionEnum);

%Fields and tolerances to track changes
field_names     ={'Gradient' 'Misfits' 'DragCoefficient' 'Pressure' 'Vel' 'Vx' 'Vy'};
field_tolerances={1e-06,1e-08,1e-09,1e-09,1e-09,1e-09,1e-09,1e-09,1e-09,1e-09};
field_values={...
	PatchToVec(md.results.DiagnosticSolution.Gradient1),...
	md.results.DiagnosticSolution.J,...
	PatchToVec(md.results.DiagnosticSolution.DragCoefficient),...
	PatchToVec(md.results.DiagnosticSolution.Pressure),...
	PatchToVec(md.results.DiagnosticSolution.Vel),...
	PatchToVec(md.results.DiagnosticSolution.Vx),...
	PatchToVec(md.results.DiagnosticSolution.Vy)
};
