function femmodel=gradient_core(femmodel,varargin),
%GRADIENT_CORE - Brief compute inverse method gradient direction
% 
%   Usage:
%       femmodel=gradient_core(femmodel,varargin);
% 
%   Examples:
%      femmodel=gradient_core(femmodel);
%      femmodel=gradient_core(femmodel,step,search_scalar);

if nargin==3,
	step=varargin{1};
	search_scalar=varargin{2};
elseif nargin==1
	step=0;
	search_scalar=0;;
else
	help gradient_core
	error('bad usage');
end

	%recover parameters common to all solutions
	verbose=femmodel.parameters.Verbose;
	num_controls=femmodel.parameters.NumControls;
	control_type=femmodel.parameters.ControlType;
	control_steady=femmodel.parameters.ControlSteady;
	optscal_list=femmodel.parameters.OptScal;

	for i=1:num_controls,

		displaystring(verbose,['      compute gradient of J with respect to %s\n'],EnumToString(control_type(i)));
		grad=Gradj(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,control_type(i));

		if control_steady,
			femmodel=diagnostic_core(femmodel);
		end

		if (step>1 && search_scalar==0),
			displaystring(verbose,'%s\n',['      orthogonalization...']);
			old_gradient=ControlInputGetGradient(femmodel.elements,femmodel.nodes, femmodel.vertices,femmodel.loads, femmodel.materials,femmodel.parameters,control_type(i));
			new_gradient=Orth(grad,old_gradient);
		else
			displaystring(verbose,'%s\n',['      normalizing direction...']);
			new_gradient=Orth(grad,[]);
		end

		 %Get scaling factor of current control:
		 norm_grad=norm(new_gradient,inf);
		 if(norm_grad<=0),     error(['||∂J/∂α||∞ = 0   gradient norm of J with respect to ' EnumToString(control_type(i))  ' is zero']); end
		 if(isnan(norm_grad)), error(['||∂J/∂α||∞ = NaN gradient norm of J with respect to ' EnumToString(control_type(i))  ' is NaN' ]); end
		 if(i==1 | (optscal_list(step,i)/norm_grad)<optscal) optscal=optscal_list(step,i)/norm_grad; end

		%plug back into inputs:
		[femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters]=ControlInputSetGradient(femmodel.elements,femmodel.nodes, femmodel.vertices,femmodel.loads, femmodel.materials,  femmodel.parameters,control_type(i),new_gradient);
	end

	%Scale all gradients
	for i=1:num_controls,
		[femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters]=ControlInputScaleGradient(femmodel.elements,femmodel.nodes, femmodel.vertices,femmodel.loads, femmodel.materials,  femmodel.parameters,control_type(i),optscal);
	end
