%Test on the diagnostic model and the prognostic in 2d
printingflag=true;

%tests 3 and 4: using Glen's flow law
md=model;
md=mesh(md,'../Exp/SquareEISMINT.exp',3550);
md=geography(md,'all','');
md=parameterize(md,'../Par/SquareEISMINT.par');
md=setelementstype(md,'macayeal','all'); %MacAyeal's model and 2d

%Impose a non zero velocity on the upper boundary condition (y=max(y))
pos=find(md.y==max(md.y));
md.spcvelocity(pos,5)=400*(((md.x(pos)-100000)/25000).^2-ones(size(pos,1),1)).*heaviside((1+eps)*ones(size(pos,1),1)-((md.x(pos)-100000)/25000).^2);

%Compute solution for MacAyeal's model 
md=solve(md,'analysis_type',DiagnosticSolutionEnum);

%plot results
md.vx=PatchToVec(md.results.DiagnosticSolution.Vx);
md.vy=PatchToVec(md.results.DiagnosticSolution.Vy);

md.dt=1;
md.ndt=5000;
md.artificial_diffusivity=1;
md=solve(md,'analysis_type',Transient2DSolutionEnum);

plotmodel(md,'data',PatchToVec(md.results.Transient2DSolution(end).Vx),'contourlevels',{0,20,40,60,60,100,120,140,160,180,-20,-40,-60,-80,-100,-120,-140,-160,-180}, ...
	'contourcolor','k')
if printingflag, 
	set(gcf,'Color','w')
	printmodel('eisminttrans2vx','png','margin','on','marginsize',25,'frame','off','resolution',2,'hardcopy','off');
	system(['mv eisminttrans2vx.png ' ISSM_DIR '/website/doc_pdf/validation/Images/EISMINT/IceShelf ']);
end

plotmodel(md,'data',PatchToVec(md.results.Transient2DSolution(end).Vy),'contourlevels',{-100,-200,-300,-400,-500,-600,-700,-800,-900,-1000},...
	'contourcolor','k')
if printingflag, 
	set(gcf,'Color','w')
	printmodel('eisminttrans2vy','png','margin','on','marginsize',25,'frame','off','resolution',2,'hardcopy','off');
	system(['mv eisminttrans2vy.png ' ISSM_DIR '/website/doc_pdf/validation/Images/EISMINT/IceShelf ']);
end

plotmodel(md,'data',PatchToVec(md.results.Transient2DSolution(end).Thickness),'contourlevels',{-100,-200,-300,-400,-500,-600,-700,-800,-900,-1000},...
	'contourcolor','k')
if printingflag, 
	set(gcf,'Color','w')
	printmodel('eisminttrans2thickness','png','margin','on','marginsize',25,'frame','off','resolution',2,'hardcopy','off');
	system(['mv eisminttrans2thickness.png ' ISSM_DIR '/website/doc_pdf/validation/Images/EISMINT/IceShelf ']);
end

%Fields and tolerances to track changes
field_names     ={'Vx','Vy','Thickness'};
field_tolerances={1e-13,1e-13};
field_values={...
	md.results.Transient2DSolution(end).Vx, ...
	md.results.Transient2DSolution(end).Vy, ...
	md.results.Transient2DSolution(end).Thickness, ...
	};
