/*!\file VerticesDofx
 * \brief: establish degrees of freedom for all vertices: */

#include "./VerticesDofx.h"

#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

void VerticesDofx( Vertices* vertices, Parameters* parameters) {

	int i;

	int  found=0;
	extern int num_procs;
	extern int my_rank;
	
	/*intermediary: */
	int  numberofvertices;

	/*figure out how many vertices we have: */
	numberofvertices=vertices->NumberOfVertices();

	/*Ensure that only for each cpu, the partition border vertices only will be taken into account once 
	 * across the cluster. To do so, we flag all the clone vertices: */
	vertices->FlagClones(numberofvertices);

	/*Go through all vertices and distribute 1 dof at a time. When a  vertex has already been distributed his dof on a cpu, 
	 * all other cpus with the same vertex cannot distribute it anymore. Use clone field to be sure of that: */
	vertices->DistributeDofs(numberofvertices,1); //only 1 dof per vertex.

}
