/*
 * UpdateElementsAndMaterialsControl:
 */

#include "../../../Container/Container.h"
#include "../../../toolkits/toolkits.h"
#include "../../../io/io.h"
#include "../../../EnumDefinitions/EnumDefinitions.h"
#include "../../../objects/objects.h"
#include "../../../shared/shared.h"
#include "../../MeshPartitionx/MeshPartitionx.h"
#include "../../../include/include.h"
#include "../ModelProcessorx.h"

void	UpdateElementsAndMaterialsControl(Elements* elements,Materials* materials, IoModel* iomodel,ConstDataHandle iomodel_handle){

	/*Intermediary*/
	int       i;
	int       counter;
	Element  *element = NULL;
	Material *material = NULL;

	/*Now, return if no control*/
	if (!iomodel->control_analysis);

	/*Fetch data needed: */
	IoModelFetchData(&iomodel->elements,NULL,NULL,iomodel_handle,"elements");
	IoModelFetchData(&iomodel->control_type,NULL,NULL,iomodel_handle,"control_type");
	IoModelFetchData(&iomodel->weights,NULL,NULL,iomodel_handle,"weights");
	IoModelFetchData(&iomodel->vx_obs,NULL,NULL,iomodel_handle,"vx_obs");
	IoModelFetchData(&iomodel->vy_obs,NULL,NULL,iomodel_handle,"vy_obs");
	IoModelFetchData(&iomodel->thickness_obs,NULL,NULL,iomodel_handle,"thickness_obs");
	for(i=0;i<iomodel->num_control_type;i++){
		switch((int)iomodel->control_type[i]){
			case DhDtEnum:
				IoModelFetchData(&iomodel->dhdt,NULL,NULL,iomodel_handle,"dhdt");
				break;
			case VxEnum:
				IoModelFetchData(&iomodel->vx,NULL,NULL,iomodel_handle,"vx");
				break;
			case VyEnum:
				IoModelFetchData(&iomodel->vy,NULL,NULL,iomodel_handle,"vy");
				break;
			case DragCoefficientEnum:
				IoModelFetchData(&iomodel->drag_coefficient,NULL,NULL,iomodel_handle,"drag_coefficient");
				break;
			case RheologyBbarEnum:
				IoModelFetchData(&iomodel->rheology_B,NULL,NULL,iomodel_handle,"rheology_B");
				break;
			default:
				ISSMERROR("Control %s not implemented yet",EnumToString((int)iomodel->control_type[i]));
		}
	}

	/*Update elements: */
	counter=0;
	for (i=0;i<iomodel->numberofelements;i++){
		if(iomodel->my_elements[i]){
			element=(Element*)elements->GetObjectByOffset(counter);
			element->Update(i,iomodel); //we need i to index into elements.

			material=(Material*)materials->GetObjectByOffset(counter);
			material->Update(i,iomodel); //we need i to index into elements.
			counter++;
		}
	}

	/*Free data: */
	xfree((void**)&iomodel->elements);
	xfree((void**)&iomodel->weights);
	xfree((void**)&iomodel->control_type);
	xfree((void**)&iomodel->vx_obs);
	xfree((void**)&iomodel->vy_obs);
	xfree((void**)&iomodel->thickness_obs);
	xfree((void**)&iomodel->dhdt);
	xfree((void**)&iomodel->vx);
	xfree((void**)&iomodel->vy);
	xfree((void**)&iomodel->drag_coefficient);
	xfree((void**)&iomodel->rheology_B);
}
