function PetscOptions2PetscFile(petscoptions,filename)
%PETSCOPTIONS2PETSCFILE: build a Petsc compatible options file, from the petscoptions model field  + return options string
%
% Usage:     PetscOptions2PetscFile(petscoptions,filename);
%
% Example:   PetscOptions2PetscFile(md.petscoptions,'petsc.rc');
%

%open file for writing
fid=fopen(filename,'w');
if fid==-1,
	error(['PetscOptions2PetscFile error: could not open ' filename ' for writing']);
end

%write header
fprintf(fid,'%s%s%s\n','%Petsc options file: ',filename,' written from Matlab petscoptions array');

%start writing options
for i=1:size(petscoptions.options,1),
	analysis=petscoptions.options{i,1};
	options=petscoptions.options{i,2};

	%first write analysis:
	fprintf(fid,'\n+%s\n',EnumToString(analysis)); %append a + to recognize it's an analysis enum

	%now, write options
	for j=1:size(options,2),
		option=options{j};
		if isempty(option),
			%do nothing
		elseif length(option)==1,
			%this option has only one argument
			fprintf(fid,'-%s\n',option{1});
		elseif length(option)==2,
			%option with value. value can be string or scalar
			if isscalar(option{2}),
				fprintf(fid,'-%s %g\n',option{1},option{2});
			elseif ischar(option{2}),
				fprintf(fid,'-%s %s\n',option{1},option{2});
			else
				error(['PetscOptions2PetscFile error: option #' num2str(j) ' is not well formatted']);
			end
		else 
			error(['PetscOptions2PetscFile error: option #' num2str(j) ' is not well formatted']);
		end
	end
end

fclose(fid);
