/*!\file ControlInputSetGradientx
 * \brief retrieve gradient from inputs in elements
 */

#include "./ControlInputSetGradientx.h"
#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

void ControlInputSetGradientx(Elements* elements,Nodes* nodes, Vertices* vertices, Loads* loads, Materials* materials, Parameters* parameters, int NameEnum,double* gradient){

	for(int i=0;i<elements->Size();i++){
		Element* element=(Element*)elements->GetObjectByOffset(i);
		element->ControlInputSetGradient(gradient,NameEnum);
	}

}
void ControlInputSetGradientx(Elements* elements,Nodes* nodes, Vertices* vertices, Loads* loads, Materials* materials, Parameters* parameters, int NameEnum,Vec gradient){

	/*Serialize gradient*/
	double* serial_gradient=NULL;
	VecToMPISerial(&serial_gradient,gradient);

	ControlInputSetGradientx(elements,nodes,vertices, loads, materials, parameters, NameEnum,serial_gradient);

	/*Clean up and return*/
	xfree((void**)&serial_gradient);
}
