function femmodel=gradient_core(femmodel,varargin),
%GRADIENT_CORE - Brief compute inverse method gradient direction
% 
%   Usage:
%       femmodel=gradient_core(femmodel,varargin);
% 
%   Examples:
%      femmodel=gradient_core(femmodel);
%      femmodel=gradient_core(femmodel,step,search_scalar);

if nargin==3,
	step=varargin{1};
	search_scalar=varargin{2};
elseif nargin==1
	step=0;
	search_scalar=0;;
else
	help gradient_core
	error('bad usage');
end

	%recover parameters common to all solutions
	verbose=femmodel.parameters.Verbose;
	control_type=femmodel.parameters.ControlType;
	control_steady=femmodel.parameters.ControlSteady;

	displaystring(verbose,'%s\n',['      compute gradient...']);
	grad=Gradj(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters);


	if control_steady;
		femmodel=diagnostic_core(femmodel);
	end

	if (step>1 && search_scalar==0),
		displaystring(verbose,'%s\n',['      orthogonalization...']);
		displaystring(verbose,'%s\n',['      retrieve old gradient...']);
		old_gradient=ControlInputGetGradient(femmodel.elements,femmodel.nodes, femmodel.vertices,femmodel.loads, femmodel.materials,femmodel.parameters,control_type);
		new_gradient=Orth(grad,old_gradient);
	else
		displaystring(verbose,'%s\n',['      normalizing direction...']);
		new_gradient=Orth(grad,[]);
	end

	%plug back into inputs:
	[femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters]=ControlInputSetGradient(femmodel.elements,femmodel.nodes, femmodel.vertices,femmodel.loads, femmodel.materials,  femmodel.parameters,control_type,new_gradient);
