/*! \file ControlInput.h 
 *  \brief: header file for triavertexinput object
 */


#ifndef _CONTROLINPUT_H_
#define _CONTROLINPUT_H_

/*Headers:*/
/*{{{1*/
#include "./Input.h"
#include "../../include/include.h"
class GaussTria;
/*}}}*/

class ControlInput: public Input{

	public:
		int    enum_type;
		Input* values;
		Input* savedvalues;
		Input* gradient;

		/*ControlInput constructors, destructors: {{{1*/
		ControlInput();
		ControlInput(int enum_type,int enum_input,double* pvalues);
		~ControlInput();
		/*}}}*/
		/*Object virtual functions definitions:{{{1 */
		void  Echo();
		void  DeepEcho();
		int   Id(); 
		int   MyRank();
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		void  Demarshall(char** pmarshalled_dataset);
		int   Enum();
		Object* copy();
		/*}}}*/
		/*ControlInput management: {{{1*/
		int    EnumType();
		Input* SpawnTriaInput(int* indices);
		Input* PointwiseDivide(Input* inputB){ISSMERROR("not implemented yet");};
		ElementResult* SpawnResult(int step, double time);
		/*}}}*/
		/*numerics: {{{1*/
		void GetParameterValue(bool* pvalue);
		void GetParameterValue(int* pvalue);
		void GetParameterValue(double* pvalue);
		void GetParameterValue(double* pvalue,GaussTria* gauss);
		void GetParameterValue(double* pvalue,GaussPenta* gauss);
		void GetParameterDerivativeValue(double* derivativevalues, double* xyz_list, GaussTria* gauss);
		void GetParameterDerivativeValue(double* derivativevalues, double* xyz_list, GaussPenta* gauss);
		void GetParameterAverage(double* pvalue);
		void GetVxStrainRate2d(double* epsilonvx,double* xyz_list, GaussTria* gauss){ISSMERROR("not implemented yet");};
		void GetVyStrainRate2d(double* epsilonvy,double* xyz_list, GaussTria* gauss){ISSMERROR("not implemented yet");};
		void GetVxStrainRate3d(double* epsilonvx,double* xyz_list, GaussPenta* gauss){ISSMERROR("not implemented yet");};
		void GetVyStrainRate3d(double* epsilonvy,double* xyz_list, GaussPenta* gauss){ISSMERROR("not implemented yet");};
		void GetVzStrainRate3d(double* epsilonvz,double* xyz_list, GaussPenta* gauss){ISSMERROR("not implemented yet");};
		void GetVxStrainRate3dPattyn(double* epsilonvx,double* xyz_list, GaussPenta* gauss){ISSMERROR("not implemented yet");};
		void GetVyStrainRate3dPattyn(double* epsilonvy,double* xyz_list, GaussPenta* gauss){ISSMERROR("not implemented yet");};
		void ChangeEnum(int newenumtype){ISSMERROR("not implemented yet");};
		void SquareMin(double* psquaremin, bool process_units,Parameters* parameters){ISSMERROR("not implemented yet");};
		void ConstrainMin(double minimum){ISSMERROR("not implemented yet");};
		void Scale(double scale_factor){ISSMERROR("not implemented yet");};
		void ArtificialNoise(double min,double max){ISSMERROR("not implemented yet");};
		void AXPY(Input* xinput,double scalar){ISSMERROR("not implemented yet");};
		void Constrain(double cm_min, double cm_max);
		double InfinityNorm(void){ISSMERROR("not implemented yet");};
		double Max(void){ISSMERROR("not implemented yet");};
		double MaxAbs(void){ISSMERROR("not implemented yet");};
		double Min(void){ISSMERROR("not implemented yet");};
		double MinAbs(void){ISSMERROR("not implemented yet");};
		void Extrude(void);
		void VerticallyIntegrate(Input* thickness_input);
		void GetVectorFromInputs(Vec vector,int* doflist){ISSMERROR("not implemented yet");};
		void GetValuesPtr(double** pvalues,int* pnum_values){ISSMERROR("not implemented yet");};
		ElementResult* SpawnGradient(int step, double time);
		void GetGradient(Vec gradient_vec,int* doflist);
		void SetGradient(Input* gradient_in);
		void UpdateValue(double scalar);
		void SaveValue(void);
		/*}}}*/

};
#endif  /* _CONTROLINPUT_H */
