/*!\file: CreateParameters.cpp
 * \brief general driver for creating parameters dataset
 */ 

#undef __FUNCT__ 
#define __FUNCT__ "CreateParameters"

#include "../DataSet/DataSet.h"
#include "../toolkits/toolkits.h"
#include "../EnumDefinitions/EnumDefinitions.h"
#include "../objects/objects.h"
#include "../shared/shared.h"
#include "../MeshPartitionx/MeshPartitionx.h"
#include "./Model.h"

void CreateParameters(DataSet** pparameters,Model* model,ConstDataHandle model_handle){
	
	int i;
	
	DataSet* parameters = NULL;
	Param*   param = NULL;
	int      count=1;
	int      analysis_type;
	int      sub_analysis_type;
	int      numberofdofspernode;
	int      dim;
	int*     epart=NULL;
	int*     part=NULL;


	/*Initialize dataset: */
	parameters   = new DataSet(ParametersEnum());

	//Get analysis_type:
	analysis_type=AnalysisTypeAsEnum(model->analysis_type);
	sub_analysis_type=AnalysisTypeAsEnum(model->sub_analysis_type);
	
	count++;
	param= new Param(count,"analysis_type",INTEGER);
	param->SetInteger(analysis_type);
	parameters->AddObject(param);

	count++;
	param= new Param(count,"sub_analysis_type",INTEGER);
	param->SetInteger(sub_analysis_type);
	parameters->AddObject(param);

	//qmu analysis?
	count++;
	param= new Param(count,"qmu_analysis",INTEGER);
	param->SetInteger(model->qmu_analysis);
	parameters->AddObject(param);

	count++;
	param= new Param(count,"qmu_npart",INTEGER);
	param->SetInteger(model->qmu_npart);
	parameters->AddObject(param);

	//dimension 2d or 3d:
	if (strcmp(model->meshtype,"2d")==0)dim=2;
	else dim=3;

	count++;
	param= new Param(count,"dim",INTEGER);
	param->SetInteger(dim);
	parameters->AddObject(param);

	//elements types
	count++;
	param= new Param(count,"ishutter",INTEGER);
	param->SetInteger(model->ishutter);
	parameters->AddObject(param);

	count++;
	param= new Param(count,"ismacayealpattyn",INTEGER);
	param->SetInteger(model->ismacayealpattyn);
	parameters->AddObject(param);

	count++;
	param= new Param(count,"isstokes",INTEGER);
	param->SetInteger(model->isstokes);
	parameters->AddObject(param);

	/*debug: */
	param= new Param(count,"debug",INTEGER);
	param->SetInteger(model->debug);
	parameters->AddObject(param);

	/*eps_rel: */
	count++;
	param= new Param(count,"eps_rel",DOUBLE);
	param->SetDouble(model->eps_rel);
	parameters->AddObject(param);

	/*eps_abs: */
	count++;
	param= new Param(count,"eps_abs",DOUBLE);
	param->SetDouble(model->eps_abs);
	parameters->AddObject(param);

	/*yts: */
	count++;
	param= new Param(count,"yts",DOUBLE);
	param->SetDouble(model->yts);
	parameters->AddObject(param);

	/*dt: */
	count++;
	param= new Param(count,"dt",DOUBLE);
	param->SetDouble(model->dt);
	parameters->AddObject(param);

	/*ndt: */
	count++;
	param= new Param(count,"ndt",DOUBLE);
	param->SetDouble(model->ndt);
	parameters->AddObject(param);

	/*penalty_offset: */
	count++;
	param= new Param(count,"penalty_offset",DOUBLE);
	param->SetDouble(model->penalty_offset);
	parameters->AddObject(param);

	/*sparsity: */
	count++;
	param= new Param(count,"sparsity",DOUBLE);
	param->SetDouble(model->sparsity);
	parameters->AddObject(param);

	/*lowmem: */
	count++;
	param= new Param(count,"lowmem",INTEGER);
	param->SetInteger(model->lowmem);
	parameters->AddObject(param);

	/*connectivity: */
	count++;
	param= new Param(count,"connectivity",INTEGER);
	param->SetInteger(model->connectivity);
	parameters->AddObject(param);

	/*beta: */
	count++;
	param= new Param(count,"beta",DOUBLE);
	param->SetDouble(model->beta);
	parameters->AddObject(param);

	/*meltingpoint: */
	count++;
	param= new Param(count,"meltingpoint",DOUBLE);
	param->SetDouble(model->meltingpoint);
	parameters->AddObject(param);

	/*latentheat: */
	count++;
	param= new Param(count,"latentheat",DOUBLE);
	param->SetDouble(model->latentheat);
	parameters->AddObject(param);

	/*heatcapacity: */
	count++;
	param= new Param(count,"heatcapacity",DOUBLE);
	param->SetDouble(model->heatcapacity);
	parameters->AddObject(param);

	/*penalty_melting: */
	count++;
	param= new Param(count,"penalty_melting",DOUBLE);
	param->SetDouble(model->penalty_melting);
	parameters->AddObject(param);

	/*min_thermal_constraints: */
	count++;
	param= new Param(count,"min_thermal_constraints",INTEGER);
	param->SetInteger(model->min_thermal_constraints);
	parameters->AddObject(param);

	/*stokesreconditioning: */
	count++;
	param= new Param(count,"stokesreconditioning",DOUBLE);
	param->SetDouble(model->stokesreconditioning);
	parameters->AddObject(param);

	/*waitonlock: */
	count++;
	param= new Param(count,"waitonlock",INTEGER);
	param->SetInteger(model->waitonlock);
	parameters->AddObject(param);

	/*solverstring: */
	count++;
	param= new Param(count,"solverstring",STRING);
	param->SetString(model->solverstring);
	parameters->AddObject(param);

	/*plot: */
	count++;
	param= new Param(count,"plot",INTEGER);
	param->SetInteger(model->plot);
	parameters->AddObject(param);

	/*numberofgrids: */
	count++;
	param= new Param(count,"numberofnodes",INTEGER);
	param->SetInteger(model->numberofnodes);
	parameters->AddObject(param);

	/*Deal with numberofdofspernode: */
	DistributeNumDofs(&numberofdofspernode,analysis_type,sub_analysis_type);

	count++;
	param= new Param(count,"numberofdofspernode",INTEGER);
	param->SetInteger(numberofdofspernode);
	parameters->AddObject(param);

	/*Deal with responses and partition for qmu modeling: */
	if(model->qmu_analysis){
		char** descriptors=NULL;
		char*  descriptor=NULL;
		char*  tag=NULL;
		int    elements_width; //size of elements

		descriptors=(char**)xmalloc(model->numberofresponses*sizeof(char*));
		tag=(char*)xmalloc((strlen("descriptori")+1)*sizeof(char));

		/*Fetch descriptors: */
		for(i=0;i<model->numberofresponses;i++){
			sprintf(tag,"%s%i","descriptor",i);
			ModelFetchData((void**)&descriptor,NULL,NULL,model_handle,tag,"String",NULL);
			descriptors[i]=descriptor;
		}

		/*Ok, we have all the descriptors. Build a parameter with it: */
		count++;
		param= new Param(count,"descriptors",STRINGARRAY);
		param->SetStringArray(descriptors,model->numberofresponses);
		parameters->AddObject(param);

		/*Free data: */
		xfree((void**)&tag);
		for(i=0;i<model->numberofresponses;i++){
			char* descriptor=descriptors[i];
			xfree((void**)&descriptor);
		}
		xfree((void**)&descriptors);

		/*Width of elements: */
		if(strcmp(model->meshtype,"2d")==0){
			elements_width=3; //tria elements
		}
		else{
			elements_width=6; //penta elements
		}

		#ifdef _PARALLEL_
		/*partition grids in model->qmu_npart parts: */
	
		if(strcmp(model->meshtype,"2d")==0){
			ModelFetchData((void**)&model->elements,NULL,NULL,model_handle,"elements","Matrix","Mat");
		}
		else{
			ModelFetchData((void**)&model->elements2d,NULL,NULL,model_handle,"elements2d","Matrix","Mat");
		}

		MeshPartitionx(&epart, &part,model->numberofelements,model->numberofnodes,model->elements, model->numberofelements2d,model->numberofnodes2d,model->elements2d,model->numlayers,elements_width, model->meshtype,model->qmu_npart);

		count++;
		param= new Param(count,"qmu_part",DOUBLEVEC);
		param->SetDoubleVec((double*)part,model->numberofnodes);
		parameters->AddObject(param);

		/*Free elements and elements2d: */
		xfree((void**)&model->elements);
		xfree((void**)&model->elements2d);
		xfree((void**)&epart);
		xfree((void**)&part);

		#endif
	}

	
	/*All our datasets are already ordered by ids. Set presort flag so that later on, when sorting is requested on these 
	 * datasets, it will not be redone: */
	parameters->Presort();

	/*Assign output pointer: */
	*pparameters=parameters;
}
