/*! \file IntVecParam.h 
 *  \brief: header file for triavertexinput object
 */


#ifndef _INTVECPARAM_H_
#define _INTVECPARAM_H_

/*Headers:*/
/*{{{1*/
#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#ifdef _SERIAL_
#include <mex.h>
#endif

#include "./Param.h"
#include "../../include/include.h"
#include "../../shared/shared.h"
/*}}}*/

class IntVecParam: public Param{

	private: 
		int enum_type;
		int* values;
		int M;

	public:
		/*IntVecParam constructors, destructors: {{{1*/
		IntVecParam();
		IntVecParam(int enum_type,int* values,int M);
		~IntVecParam();
		/*}}}*/
		/*Object virtual functions definitions:{{{1 */
		void  Echo();
		void  DeepEcho();
		int   Id(); 
		int   MyRank();
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		void  Demarshall(char** pmarshalled_dataset);
		int   Enum();
		Object* copy();
		/*}}}*/
		/*Param virtual functions definitions: {{{1*/
		int   EnumType(){return enum_type;}
		void  GetParameterValue(bool* pbool){ISSMERROR("IntVec param of enum %i (%s) cannot return a bool",enum_type,EnumToString(enum_type));}
		void  GetParameterValue(int* pinteger){ISSMERROR("IntVec param of enum %i (%s) cannot return an integer",enum_type,EnumToString(enum_type));}
		void  GetParameterValue(int** pintarray,int* pM);
		void  GetParameterValue(double* pdouble){ISSMERROR("IntVec param of enum %i (%s) cannot return a double",enum_type,EnumToString(enum_type));}
		void  GetParameterValue(char** pstring){ISSMERROR("IntVec param of enum %i (%s) cannot return a string",enum_type,EnumToString(enum_type));}
		void  GetParameterValue(char*** pstringarray,int* pM){ISSMERROR("IntVec param of enum %i (%s) cannot return a string arrayl",enum_type,EnumToString(enum_type));}
		void  GetParameterValue(double** pdoublearray,int* pM);
		void  GetParameterValue(double** pdoublearray,int* pM, int* pN){ISSMERROR("IntVec param of enum %i (%s) cannot return a double array",enum_type,EnumToString(enum_type));}
		void  GetParameterValue(double*** parray, int* pM,int** pmdims, int** pndims){ISSMERROR("IntVec param of enum %i (%s) cannot return a matrix array",enum_type,EnumToString(enum_type));}
		void  GetParameterValue(Vec* pvec){ISSMERROR("IntVec param of enum %i (%s) cannot return a Vec",enum_type,EnumToString(enum_type));}
		void  GetParameterValue(Mat* pmat){ISSMERROR("IntVec param of enum %i (%s) cannot return a Mat",enum_type,EnumToString(enum_type));}
		void  GetParameterValue(FILE** pfid){ISSMERROR("IntVec param of enum %i (%s) cannot return a FILE",enum_type,EnumToString(enum_type));}

		void  SetValue(bool boolean){ISSMERROR("IntVec param of enum %i (%s) cannot hold a boolean",enum_type,EnumToString(enum_type));}
		void  SetValue(int integer){ISSMERROR("IntVec param of enum %i (%s) cannot hold an integer",enum_type,EnumToString(enum_type));}
		void  SetValue(int* intarray,int M);
		void  SetValue(double scalar){ISSMERROR("IntVec param of enum %i (%s) cannot hold a scalar",enum_type,EnumToString(enum_type));}
		void  SetValue(char* string){ISSMERROR("IntVec param of enum %i (%s) cannot hold a string",enum_type,EnumToString(enum_type));}
		void  SetValue(char** stringarray,int M){ISSMERROR("IntVec param of enum %i (%s) cannot hold a string array",enum_type,EnumToString(enum_type));}
		void  SetValue(double* doublearray,int M);
		void  SetValue(double* pdoublearray,int M,int N){ISSMERROR("IntVec param of enum %i (%s) cannot hold a double mat array",enum_type,EnumToString(enum_type));}
		void  SetValue(Vec vec){ISSMERROR("IntVec param of enum %i (%s) cannot hold a Vec",enum_type,EnumToString(enum_type));}
		void  SetValue(Mat mat){ISSMERROR("IntVec param of enum %i (%s) cannot hold a Mat",enum_type,EnumToString(enum_type));}
		void  SetValue(FILE* fid){ISSMERROR("IntVec param of enum %i (%s) cannot hold a FILE",enum_type,EnumToString(enum_type));}
		void  SetValue(double** array, int M, int* mdim_array, int* ndim_array){ISSMERROR("IntVec param of enum %i (%s) cannot hold an array of matrices",enum_type,EnumToString(enum_type));}
		
		char* GetParameterName(void);
		#ifdef _SERIAL_
		void  SetMatlabField(mxArray* dataref);
		#endif
		/*}}}*/
};
#endif
