/*! \file FileParam.h 
 *  \brief: header file for triavertexinput object
 */


#ifndef _FILEPARAM_H_
#define _FILEPARAM_H_

/*Headers:*/
/*{{{1*/
#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#ifdef _SERIAL_
#include <mex.h>
#endif

#include "./Param.h"
#include "../../include/include.h"
#include "../../shared/shared.h"
/*}}}*/

class FileParam: public Param{

	private: 
		int   enum_type;
		FILE* value;

	public:
		/*FileParam constructors, destructors: {{{1*/
		FileParam();
		FileParam(int enum_type,FILE* fid);
		~FileParam();
		/*}}}*/
		/*Object virtual functions definitions:{{{1 */
		void  Echo();
		void  DeepEcho();
		int   Id(); 
		int   MyRank();
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		void  Demarshall(char** pmarshalled_dataset);
		int   Enum();
		Object* copy();
		/*}}}*/
		/*Param vritual function definitions: {{{1*/
		int   EnumType(){return enum_type;}
		void  GetParameterValue(bool* pbool){  ISSMERROR("FileParam of enum %i (%s) cannot return a bool",enum_type,EnumToString(enum_type));}
		void  GetParameterValue(int* pinteger){ISSMERROR("FileParam of enum %i (%s) cannot return a double",enum_type,EnumToString(enum_type));}
		void  GetParameterValue(int** pintarray,int* pM){ISSMERROR("FileParam of enum %i (%s) cannot return a double",enum_type,EnumToString(enum_type));}
		void  GetParameterValue(double* pdouble){ISSMERROR("FileParam of enum %i (%s) cannot return a double",enum_type,EnumToString(enum_type));}
		void  GetParameterValue(char** pstring){ISSMERROR("FileParam of enum %i (%s) cannot return a string",enum_type,EnumToString(enum_type));}
		void  GetParameterValue(char*** pstringarray,int* pM){ISSMERROR("FileParam of enum %i (%s) cannot return a string arrayl",enum_type,EnumToString(enum_type));}
		void  GetParameterValue(double** pdoublearray,int* pM){ISSMERROR("FileParam of enum %i (%s) cannot return a double array",enum_type,EnumToString(enum_type));}
		void  GetParameterValue(double** pdoublearray,int* pM, int* pN){ISSMERROR("FileParam of enum %i (%s) cannot return a double array",enum_type,EnumToString(enum_type));}
		void  GetParameterValue(double*** parray, int* pM,int** pmdims, int** pndims){ISSMERROR("File param of enum %i (%s) cannot return a matrix array",enum_type,EnumToString(enum_type));}
		void  GetParameterValue(Vec* pvec){ISSMERROR("FileParam of enum %i (%s) cannot return a Vec",enum_type,EnumToString(enum_type));}
		void  GetParameterValue(Mat* pmat){ISSMERROR("FileParam of enum %i (%s) cannot return a Mat",enum_type,EnumToString(enum_type));}
		void  GetParameterValue(FILE** pfid){*pfid=value;};

		void  SetValue(bool boolean){ISSMERROR("FileParam of enum %i (%s) cannot hold a string",enum_type,EnumToString(enum_type));}
		void  SetValue(int integer){ISSMERROR("FileParam of enum %i (%s) cannot hold a string",enum_type,EnumToString(enum_type));}
		void  SetValue(int* intarray,int M){ISSMERROR("FileParam of enum %i (%s) cannot hold a string",enum_type,EnumToString(enum_type));}
		void  SetValue(double scalar){ISSMERROR("FileParam of enum %i (%s) cannot hold a string",enum_type,EnumToString(enum_type));}
		void  SetValue(char* string){ISSMERROR("FileParam of enum %i (%s) cannot hold a string",enum_type,EnumToString(enum_type));}
		void  SetValue(char** stringarray,int M){ISSMERROR("FileParam of enum %i (%s) cannot hold a string array",enum_type,EnumToString(enum_type));}
		void  SetValue(double* doublearray,int M){ISSMERROR("FileParam of enum %i (%s) cannot hold a double array",enum_type,EnumToString(enum_type));}
		void  SetValue(double* pdoublearray,int M,int N){ISSMERROR("FileParam of enum %i (%s) cannot hold a double array",enum_type,EnumToString(enum_type));}
		void  SetValue(Vec vec){ISSMERROR("FileParam of enum %i (%s) cannot hold a Vec",enum_type,EnumToString(enum_type));}
		void  SetValue(Mat mat){ISSMERROR("FileParam of enum %i (%s) cannot hold a Mat",enum_type,EnumToString(enum_type));}
		void  SetValue(FILE* fid){ISSMERROR("File param of enum %i (%s) cannot hold a FILE",enum_type,EnumToString(enum_type));}
		void  SetValue(double** array, int M, int* mdim_array, int* ndim_array){ISSMERROR("File param of enum %i (%s) cannot hold an array of matrices",enum_type,EnumToString(enum_type));}

		char* GetParameterName(void);
		#ifdef _SERIAL_
		void  SetMatlabField(mxArray* dataref);
		#endif

		/*}}}*/
};
#endif  /* _INTPARAM_H */
