/*! \file BoolParam.h 
 *  \brief: header file for triavertexinput object
 */


#ifndef _BOOLPARAM_H_
#define _BOOLPARAM_H_

/*Headers:*/
/*{{{1*/
#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#ifdef _SERIAL_
#include <mex.h>
#endif

#include "./Param.h"
#include "../../include/include.h"
#include "../../shared/shared.h"
/*}}}*/

class BoolParam: public Param{

	public:
		/*just hold 3 values for 3 vertices: */
		int enum_type;
		IssmBool value;

		/*BoolParam constructors, destructors: {{{1*/
		BoolParam();
		BoolParam(int enum_type,IssmBool value);
		~BoolParam();
		/*}}}*/
		/*Object virtual functions definitions:{{{1 */
		void  Echo();
		void  DeepEcho();
		int   Id(); 
		int   MyRank();
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		void  Demarshall(char** pmarshalled_dataset);
		int   Enum();
		Object* copy();
		/*}}}*/
		/*Param vritual function definitions: {{{1*/
		int   EnumType(){return enum_type;}
		void  GetParameterValue(bool* pbool){*pbool=value;}
		void  GetParameterValue(int* pinteger){ISSMERROR("Bool param of enum %i (%s) cannot return an integer",enum_type,EnumToString(enum_type));}
		void  GetParameterValue(int** pintarray,int* pM){ISSMERROR("Bool param of enum %i (%s) cannot return an array of integers",enum_type,EnumToString(enum_type));}
		void  GetParameterValue(double* pdouble){ISSMERROR("Bool param of enum %i (%s) cannot return a double",enum_type,EnumToString(enum_type));}
		void  GetParameterValue(char** pstring){ISSMERROR("Bool param of enum %i (%s) cannot return a string",enum_type,EnumToString(enum_type));}
		void  GetParameterValue(char*** pstringarray,int* pM){ISSMERROR("Bool param of enum %i (%s) cannot return a string arrayl",enum_type,EnumToString(enum_type));}
		void  GetParameterValue(double** pdoublearray,int* pM){ISSMERROR("Bool param of enum %i (%s) cannot return a double array",enum_type,EnumToString(enum_type));}
		void  GetParameterValue(double** pdoublearray,int* pM, int* pN){ISSMERROR("Bool param of enum %i (%s) cannot return a double array",enum_type,EnumToString(enum_type));}
		void  GetParameterValue(double*** parray, int* pM,int** pmdims, int** pndims){ISSMERROR("Bool param of enum %i (%s) cannot return a matrix array",enum_type,EnumToString(enum_type));}
		void  GetParameterValue(Vec* pvec){ISSMERROR("Bool param of enum %i (%s) cannot return a Vec",enum_type,EnumToString(enum_type));}
		void  GetParameterValue(Mat* pmat){ISSMERROR("Bool param of enum %i (%s) cannot return a Mat",enum_type,EnumToString(enum_type));}
		void  GetParameterValue(FILE** pfid){ISSMERROR("Bool param of enum %i (%s) cannot return a FILE",enum_type,EnumToString(enum_type));}

		void  SetValue(bool boolean){this->value=boolean;}
		void  SetValue(int integer){this->value=(bool)integer;}
		void  SetValue(int* intarray,int M){ISSMERROR("Bool param of enum %i (%s) cannot hold an int array",enum_type,EnumToString(enum_type));}
		void  SetValue(double scalar){this->value=(bool)scalar;}
		void  SetValue(char* string){ISSMERROR("Bool param of enum %i (%s) cannot hold a string",enum_type,EnumToString(enum_type));}
		void  SetValue(char** stringarray,int M){ISSMERROR("Bool param of enum %i (%s) cannot hold a string array",enum_type,EnumToString(enum_type));}
		void  SetValue(double* doublearray,int M){ISSMERROR("Bool param of enum %i (%s) cannot hold a double array",enum_type,EnumToString(enum_type));}
		void  SetValue(double* pdoublearray,int M,int N){ISSMERROR("Bool param of enum %i (%s) cannot hold a double array",enum_type,EnumToString(enum_type));}
		void  SetValue(Vec vec){ISSMERROR("Bool param of enum %i (%s) cannot hold a Vec",enum_type,EnumToString(enum_type));}
		void  SetValue(Mat mat){ISSMERROR("Bool param of enum %i (%s) cannot hold a Mat",enum_type,EnumToString(enum_type));}
		void  SetValue(FILE* fid){ISSMERROR("Bool param of enum %i (%s) cannot hold a FILE",enum_type,EnumToString(enum_type));}
		void  SetValue(double** array, int M, int* mdim_array, int* ndim_array){ISSMERROR("Bool param of enum %i (%s) cannot hold an array of matrices",enum_type,EnumToString(enum_type));}
		
		char* GetParameterName(void);
		#ifdef _SERIAL_
		void  SetMatlabField(mxArray* dataref);
		#endif
		/*}}}*/
};
#endif  /* _BOOLPARAM_H */
